﻿var panelPoints = {
    datatable: null,
    filterDefinition: "",
    refreshDataTable: function () {
        panelPoints.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".v-panelPointsTable").a4datatable({
            advancedFilter: true,
            displaySearchBox: false,
            ajaxAction: a4.getAction("GetPanelPoints", "Panelists", "Panel"),
            ajaxParams: { "customParams": { "filter": panelPoints.filterDefinition, "ActionType": $("#ActionType").val(), SelectedPanelistsJson: $("#SelectedPanelistsJson").val()} },
            columns: [
                { "Name": "PanelistId", "Title": resources.PanelistId, "Data": "PanelistId", "Type": "numeric", "Width": "100px" },
                { "Name": "UserName", "Title": resources.UserName, "Data": "UserName" },
                { "Name": "FirstName", "Title": resources.FirstName, "Data": "FirstName", "Visible": false },
                { "Name": "LastName", "Title": resources.LastName, "Data": "LastName", "Visible": false },
                { "Name": "SourceEnumVal", "Title": resources.Source, "Data": "SourceFormatted", "Type": "enum", "EnumType": "PointsSource", "Width": "125px" },
                { "Name": "OperationEnumVal", "Title": resources.Operation, "Data": "OperationFormatted", "Type": "enum", "EnumType": "PointsOperation" },
                { "Name": "Points", "Title": resources.Points, "Data": "Points", "Type": "numeric" },
                { "Name": "DateTime", "Title": resources.DateTime, "Data": "DateTime", "Type": "datetime" },
                { "Name": "Message", "Title": resources.Message, "Data": "FormatedMessage", "Sortable": false },
            ],
            lengthMenu: [
                [10, 20, 50, 100, 500, 1000],
                ['10', '20', '50', '100', '500', '1000']
            ],
            defaultSorting: { Column: "DateTime", Ascending: false }
        });
    },
    bindEvents: function () {
        $(document).on("click", ".h-exportPanelPoints", function () {
            a4.showBusyBox();
            var tableParams = JSON.stringify(panelPoints.datatable.a4datatable("getTableParams"));
            var uri = a4.getAction("GeneratePanelPointsExport", "Panelists", "Panel");
            var model = { "panelPointsExportModel": { "PanelistFilter": panelPoints.filterDefinition, "ActionType": $("#ActionType").val(), "TableParams": tableParams, selectedPanelistsJson : $("#SelectedPanelistsJson").val() } };

            a4.callServerMethod(uri, model, function (result) {
                if (result != null && result.length > 0) {
                    var src = a4.getAction("ExportPanelists", "Panelists", "Panel", { GetFile: result });
                    modalDialog.close();
                    a4.hideBusyBox();
                    a4.parent().location.replace(src);
                }
            },
            function (result) {
                a4.hideBusyBox();
            },
            {
                complete: function (jqXHR, textStatus) {
                    if (textStatus == "timeout") {
                        a4.showErrorMessage(resources.TimeoutErrorMessage);
                    }
                }
            });
        });

        $(document).on("click", ".h-addTransactionInBatch", function () {
            var actionType = $("#ActionType").val();
            var actionMethod = "";

            switch (actionType) {
                case "Selected": actionMethod = "SelectedPanelBatchNewPointsTransaction";
                    break;
                case "Filtered": actionMethod = "FilteredPanelistBatchNewPointsTransaction";
                    break;
                default: actionMethod = "PanelBatchNewPointsTransaction";
            }

            panelPointCommon.addTransactionPointToPanelist(actionType, actionMethod, panelPoints);
        });
    }
}

$(document).ready(function () {
    if ($(".v-panelPointsTable").length > 0) {
        panelPoints.filterDefinition = $("#PanelistsFilter").val();
        panelPoints.bindEvents();
        panelPoints.initializeDataTable();
    }
});
